<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WalletTransaction extends Model
{
    use HasFactory;

    protected $table = 'wallet_transaction';

    protected $fillable = [
       'transaction_amount',
        'transaction_name',
        'receipt',
        'transaction_narration',
        'transaction_id',
        'bank_name',
        'account_number',
    ];

    protected $casts = [
        'transaction_amount' => 'double'
    ];

    public function userWallet() {
        return $this->belongsTo(UserWallet::class);
    }
}
