<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SmallFormatAds extends Model
{
    use HasFactory;

    protected $table = 'small_format_ads';
    protected $fillable = [
        'purpose_application',
        'payment_id',
        'address_site',
        'lga',
        'property_owner_phone',
        'property_owner_email',
        'longitude',
        'latitude',
        'assigned_officer',
    ];
    
    protected $casts = [
       'inspection_fee' => 'double',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function smallFormatDetails() {
         return $this->hasMany(SmallFormatDetails::class);
    }

    public function paymentSmallFormatAds() {
        return $this->hasMany(PaymentSmallFormatAds::class);
    }
    
    public function smallformatreceipts() {
        return $this->hasMany(SmallFormatReceipts::class);
    }
}
