<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnpremiseApplicationPricingRule extends Model
{
    use HasFactory;
    
    protected $table = 'onpremise_application_pricing_rules';

    protected $fillable = [
        'property_type',
        'sign_type',
        'base_price',
        'additional_sign_price',
        'combination_rules',
        'app_type'
    ];

    protected $casts = [
        'combination_rules' => 'array',
        'base_price' => 'double',
        'additional_sign_price' => 'double'
    ];

    /**
     * Get pricing rule for specific property and sign type
     */
    public static function getRule(string $propertyType, string $signType)
    {
        return static::where('property_type', $propertyType)
            ->where('sign_type', $signType)
            ->first();
    }

    /**
     * Get all pricing rules for a property type
     */
    public static function getRulesForPropertyType(string $propertyType, string $apptype)
    {
        return static::where('property_type', $propertyType)->where('app_type', $apptype)
            ->get()
            ->keyBy('sign_type');
    }
}