<?php
ini_set('memory_limit', '10240M');

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
//
//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//    return $request->user();
//});

Route::controller(\App\Http\Controllers\Api\AuthController::class)->group( function () {
    Route::post('login', 'login');
    Route::post('register', 'register');
    Route::post('logout',  'logout');
    Route::get('getuser', 'getUserInfo');
    Route::patch('setusertype', 'setUserType');
    Route::post('checkemailorphone', 'checkEmailorPhone');
    Route::patch('checktoken', 'checkToken');
    Route::patch('checktokenreg', 'checkTokenReg');
    Route::patch('changepassword', 'changePassword');
    Route::post('testbrevo', 'testbrevo');
    Route::get('saveinstitution/{id}', 'saveInstitution');
});

Route::controller(\App\Http\Controllers\Api\KycController::class)->group(function () {
    Route::post('registerkyc', 'registerKycDetails');
});

Route::controller(\App\Http\Controllers\Api\AdsApplicationController::class)->group(function () {
    Route::post('onpremise', 'onPremise');
    Route::post('onpremisebulk', 'onPremiseBulk');
    Route::post('forbulkupload', 'forbulkupload');
    Route::post('forbulkapplicationfeepayment/{id}', 'forbulkApplicationFeepayment');
    Route::post('removeonpremisesign/{id}', 'removeOnpremiseSign');
    Route::post('addonpremisesign/{id}', 'AddOnPremise');
    Route::post('changeonpremisesign/{id}', 'ChangeOnPremise');
    Route::post('editonpremise/{id}', 'EditOnPremise');
    Route::post('editinfoonpremise', 'EditInfoOnPremise');
    Route::post('editadditionalinfoonpremise', 'EditAdditionalInfoOnPremise');
    Route::post('editchangeonpremise', 'EditChangeOnPremise');
    Route::post('editsubmitonpremise/{id}', 'EditSubmitOnPremise');
    Route::post('editadditionalsubmitonpremise/{id}', 'EditAdditionalSubmitOnPremise');
    Route::post('mobileads', 'mobileAds');
    Route::post('streetlamp', 'streetLampAds');
    Route::post('expressionstreetlamp', 'expressionStreetLamps');
    Route::post('confirmpayment', 'setPaymentReference');
    Route::post('thirdpartymobile','thirdPartyMobileAds');
    Route::post('getpaymentinfo', 'getPaymentInfo');
    Route::delete('deletebulkonpremise/{id}', 'DeleteBulkOnPremise');
    Route::delete('deleteonpremise/{id}', 'DeleteOnPremise');
    Route::middleware('paystack.ip')->post('confirmapplicationpayment', 'setPaymentReferencePaystackApplication');
});

Route::controller(App\Http\Controllers\Api\AdminController::class)->group(function()  {
    Route::post('adminlogin', 'adminLogin');
    Route::middleware(['auth:adminapi', 'last.login'])->post('adminregister', 'adminRegister');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getalladmin', 'getAllAdmin');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getrmregistry', 'getRMRegistry');
    Route::middleware(['auth:adminapi','last.login'])->get('getassignableadmin', 'getHodAndGm');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getcurrentadmin', 'getCurrentAdmin');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getonpremise', 'getAllOnpremiseApps');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getmobile', 'getAllMobileApps');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getstreetlamp', 'getAllStreetLampApps');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getthirdpartymobile', 'getAllThirdPartyMobileApps');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getfirstpartyonpremise', 'getFirstPartyOnpremiseForBM');
    Route::middleware(['auth:adminapi', 'last.login'])->get('activitytimeline', 'getActivityTimeline');
    Route::middleware(['auth:adminapi', 'last.login'])->get('adminlogout', 'adminLogout');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getmobiletask', 'getAllMobileAppsMytask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getthirdpartymobiletask', 'getAllThirdPartyMobileAppsMytask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getstreetlamptask', 'getAllStreetLampAppsMytask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getonpremisetask', 'getAllOnpremiseAppsMytask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getthirdpartyeoitask', 'getAllThirdPartyKycMytask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getthirdpartyoutdoorsignagetask', 'getAllThirdPartyOutdoorSignageTask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getoffchargeandexpunctiontask', 'getAllThirdPartyOffchargeandExpunctionTask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getupgradeanddowngradetask', 'getAllThirdPartyUpgradeAndDowngradeTask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getsmallformattask', 'getAllSmallFormatMyTask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('gettemporaryadstask', 'getAllTemporaryAdsMyTask');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getemailcontent', 'getEmailContent');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateemailcontent/{id}', 'updateEmailContent');
});

Route::controller(\App\Http\Controllers\Api\UserAdsApplicationController::class)->group(function () {
    Route::get('getuseronpremiseads', 'getUserOnpremiseAds');
    Route::get('getusermobileads', 'getUserMobileAds');
    Route::get('getuserstreetlampsads', 'getUserStreetLampsAds');
    Route::get('getuserthirdpartyads', 'getUserThirdPartyAds');
});

Route::controller(\App\Http\Controllers\Api\UserAdsDetailsController::class)->group(function () {
    Route::middleware('auth:api')->get('getmobileadsdetails/{id}', 'getUserMobileAds');
    Route::middleware('auth:api')->get('getthirdpartymobiledetails/{id}', 'getThirdPartyMobileAds');
    Route::middleware('auth:api')->get('getstreetlampdetails/{id}', 'getStreetLampAds');
    Route::middleware('auth:api')->get('getonpremisedetails/{id}','getOnpremiseAds');
    Route::middleware('auth:api')->post('userdeclinestreetlampsads/{id}','userDeclineStreetLampsAds');
});

Route::controller(\App\Http\Controllers\Api\UserAdsDetailsController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetmobileadsdetails/{id}', 'getUserMobileAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetthirdpartymobiledetails/{id}', 'getThirdPartyMobileAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetstreetlampdetails/{id}', 'getStreetLampAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetonpremisedetails/{id}', 'getOnpremiseAds');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatestreetlampapplicationpricing/{id}', 'updateStreetLampApplicationPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getstreetlampapplicationpricing', 'getStreetLampApplicationPricing');
});

Route::controller(\App\Http\Controllers\Api\AdminApprovalController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinemobileads/{id}', 'declineMobileAds');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinethirdpartymobile/{id}', 'declineThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedonpremise/{id}', 'declinedOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedremovalonpremise/{id}', 'declinedRemovalOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedadditionalonpremise/{id}', 'declinedAdditionalOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedchangeonpremise/{id}', 'declinedChangeOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedstreetlamp/{id}', 'declinedStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('declinedexpresionintereststreetlamp/{id}', 'declinedExpresionInterestStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvemobileads/{id}', 'approveMobileAds');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvethirdpartymobile/{id}', 'approveThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveonpremise/{id}', 'approveOnpremise');
    // Route::post('approveonpremise/{id}', 'approveOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('admineditonpremise/{id}', 'AdminEditOnPremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('deleteonpremisedetails/{id}', 'DeleteOnPremiseDetails');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvermonpremise/{id}', 'approveRmOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvehodonpremise/{id}', 'approveHODOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvebillingonpremise/{id}', 'approveBillingOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvebillinginfoonpremise/{id}', 'approveBillingInfoOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('enabledisableproductonsign/{id}', 'EnableDisableProductOnSign');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveaccountonpremise/{id}', 'approveAccountOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveauditonpremise/{id}', 'approveAuditOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovalonpremise/{id}', 'approveRemovalOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovalcponpremise/{id}', 'approveRemovalCPOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovalrmonpremise/{id}', 'approveRemovalRmOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovalhodonpremise/{id}', 'approveRemovalHODOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovebillingonpremise/{id}', 'approveRemoveBillingOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveremovalauditonpremise/{id}', 'approveRemovalAuditOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalonpremise/{id}', 'approveAdditionalOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalcponpremise/{id}', 'approveAdditionalCPOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalrmonpremise/{id}', 'approveAdditionalRmOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalhodonpremise/{id}', 'approveAdditionalHODOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalbillingonpremise/{id}', 'approveAdditionalBillingOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalaccountonpremise/{id}', 'approveAdditionalAccountOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveadditionalauditonpremise/{id}', 'approveAdditionalAuditOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangeonpremise/{id}', 'approveChangeOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangecponpremise/{id}', 'approveChangeCPOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangermonpremise/{id}', 'approveChangeRmOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangehodonpremise/{id}', 'approveChangeHODOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangebillingonpremise/{id}', 'approveChangeBillingOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvechangeauditonpremise/{id}', 'approveChangeAuditOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approvestreetlamp/{id}', 'approveStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('approveExpressionInterestStreetLamp/{id}', 'approveExpressionInterestStreetLamp');
    Route::middleware('auth:api')->get('getonpremisedownloadables/{id}', 'getOnpremiseDownloadables');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getonpremisepricing', 'getOnpremisePricing');
    Route::get('getonpremisepricingdistinct', 'getOnpremisePricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getstreetlamppricing', 'getStreetLampPricing');
    Route::get('getstreetlamppricingdistinct', 'getStreetLampPricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getmobileadspricing', 'getMobileAdsPricing');
    Route::get('getmobileadspricingdistinct', 'getMobileAdsPricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deletemobilesdspricing/{id}', 'deleteMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getmobileadsapplicationpricing', 'getMobileAdsApplicationPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getthirdpartymobileadspricing', 'getThirdPartyMobileAdsPricing');
    Route::get('getthirdpartymobileadspricingdistinct', 'getThirdPartyMobileAdsPricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->post('editonpremisepricing', 'editOnpremisePricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createonpremisepricing', 'createOnpremisePricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deleteonpremisepricing/{id}', 'deleteOnpremisePricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deletethirdpartymobileadspricing/{id}', 'deleteThirdPartyMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatestreetlamppricing/{id}', 'updateStreetLampPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createstreetlamppricing', 'createStreetLampPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deletestreetlamppricing/{id}', 'deleteStreetLampPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatemobileadspricing/{id}', 'updateMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createmobileadspricing', 'createMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatemobileadsapplicationpricing/{id}', 'updateMobileAdsApplicationPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatethirdpartymobileadspricing/{id}', 'updateThirdPartyMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createthirdpartymobileadspricing', 'createThirdPartyMobileAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getonpremiseapplicationpricingpules', 'getOnpremiseApplicationPricingRules');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateonpremiseapplicationpricing', 'updateOnpremiseApplicationPricing');
});

Route::controller(\App\Http\Controllers\Api\PaymentController::class)->group(function() {
    Route::get('mobileadspayment/{id}', 'mobileAdsPayment');
    Route::get('thirdpartymobilepayment/{id}', 'thirdPartyMobilePayment');
    Route::get('streetlamppayment/{id}', 'streetLampPayment');
    Route::get('onpremisepayment/{id}', 'onpremisePayment');
    Route::get('bulkonpremisepermitfeepayment', 'bulkOnpremisePermitFeepayment');
    Route::get('outdoorsignagepayment/{id}', 'outdoorSignagePayment');
    Route::get('kycthirdpartypayment/{id}', 'kycThirdPartyPayment');
    Route::get('getoutdoorsignagearrears/{id}', 'getArrearsforOutdoor');
    Route::get('getbulkarrearsforoutdoor', 'getBulkArrearsforOutdoor');
    Route::get('firstpartytemporarypayment/{id}', 'firstPartyTemporaryAds');
    Route::get('smallformatdetailspayment/{id}', 'smallFormatDetailsPayment');
    Route::get('getsmallformatdetailsarrears/{id}', 'getSmallFormatDetailsArrears');
    Route::get('getbulksmallformatdetailsarrears', 'getBulkSmallFormatDetailsArrears');
    Route::post('setadspaymentinfo', 'setAdsPaymentInfo');
    Route::post('sendtemporaryadsapproveletter/{id}', 'sendTemporaryAdsApprovalLetter');
    Route::post('sendsmallformatadsapproveletter/{id}', 'getSmallFormatApprovalLetter');
    Route::middleware('paystack.ip')->post('getpaymentreference', 'setPaymentReferencePaystack');
});

Route::controller(\App\Http\Controllers\Api\HODApprovalController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddeclinemobile/{id}', 'hodDeclineMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddeclinethirdpartymobile/{id}', 'hodDeclineThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddeclinestreetlamp/{id}', 'hodDeclineStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapprovalmobile/{id}', 'hodApprovalMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapprovalthirdpartymobile/{id}', 'hodApprovalThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapprovalstreetlamp/{id}', 'hodApprovalStreetLamp');
});

Route::controller(\App\Http\Controllers\Api\FinalApprovalController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->post('finaldeclineformobile/{id}', 'finalDeclineForMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finaldeclineforthirdpartymobile/{id}', 'finalDeclineForThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finaldeclineforstreetlamp/{id}', 'finalDeclineForStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finaldeclineforonpremise/{id}', 'finalDeclineForOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finalapproveformobile/{id}', 'finalApproveForMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finalapproveforthirdparty/{id}', 'finalApproveForThirdParty');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finalapproveforstreetlamp/{id}', 'finalApproveForStreetLamp');
    Route::middleware(['auth:adminapi', 'last.login'])->post('finalapproveforonpremise/{id}', 'finalApproveForOnpremise');
});

Route::controller(\App\Http\Controllers\Api\QrCodeController::class)->group(function () {
    Route::get('generatestreetlampqrcode/{id}','generateStreetLampQrcode');
    Route::get('generatethirdpartymobile/{id}', 'generateThirdPartyMobile');
});

Route::controller(\App\Http\Controllers\Api\StreetLampInfoController::class)->group(function () {
    Route::get('deletestreetlampInfo/{id}', 'deleteStreetLampInfo');
});

Route::controller(\App\Http\Controllers\Api\WalletController::class)->group(function () {
    Route::get('getuserwallet', 'getUserWallet');
    Route::post('savewallettransaction', 'saveWalletTransaction');
});

Route::controller(\App\Http\Controllers\Api\AdminOperationController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('getalluserdetails', 'getAllUserDetails');
    Route::middleware(['auth:adminapi', 'last.login'])->get('paginateuserdetails', 'paginateUserDetails');
    Route::middleware(['auth:adminapi', 'last.login'])->get('pagegetuserinfo/{id}', 'pageGetUserInfo');
    Route::middleware(['auth:adminapi', 'last.login'])->post('debitcreditnote/{id}', 'onPremiseDebitNote');
    Route::middleware(['auth:adminapi', 'last.login'])->post('debitnoteprodlist/{id}/{productType}', 'DebitNoteProdList');
    Route::middleware(['auth:adminapi', 'last.login'])->get('outdoorreassign/{id}/{newadmin}', 'outdoorReassign');
    Route::middleware(['auth:adminapi', 'last.login'])->get('outdoorreversereassign/{id}', 'outdoorReverseReassign');
    Route::middleware(['auth:adminapi', 'last.login'])->post('registeruser', 'registerUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createmobileadsforuser', 'createMobileAdsforUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createthirdpartymobileforuser', 'createThirdPartyMobileforUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createstreetlampforuser', 'createStreetLampforUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createonpremiseforuser', 'createOnpremiseforUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateuserwalletbalance/{id}', 'updateUserWalletBalance');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getwallettransaction', 'getWalletTransaction');
    Route::middleware(['auth:adminapi', 'last.login'])->post('savewallettransactionforuser', 'saveWalletTransactionforUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('paymobilewallet/{id}/{referenceId}', 'payMobileForUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('paypavwallet/{id}/{referenceId}', 'payThirdpartyMobileForUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('payslppermitwallet/{id}/{referenceId}', 'payStreetLampForUser');
    Route::middleware(['auth:adminapi', 'last.login'])->post('payslpappwallet/{id}/{referenceId}', 'payAppStreetLampForUser');

});

Route::controller(\App\Http\Controllers\Api\LegalApprovalController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->post('legalapprovalformobile/{id}', 'legalApprovalForMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legalapprovalforonpremise/{id}', 'legalApprovalForOnpremise');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legalapprovalforthirdpartymobile/{id}', 'legalApprovalForThirdPartyMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legalapprovalforstreetlamp/{id}', 'legalApprovalForStreetLamp');
});

Route::controller(\App\Http\Controllers\Api\PaymentHistoryController::class)->group(function () {
    Route::get('getmobilepayment', 'getMobilePaymentHistory');
    Route::get('getthirdpartymobilepayment', 'getThirdPartyMobilePaymentHistory');
    Route::get('getstreetlamppayment', 'getStreetLampPaymentHistory');
    Route::get('getonpremisepayment', 'getOnpremisePaymentHistory');
});

Route::controller(\App\Http\Controllers\Api\ExternalController::class)->group(function () {
    Route::middleware('whitelist.ip')->patch('getqrcodedetails', 'getQrCodeDetails');
});

Route::controller(\App\Http\Controllers\Api\EditAdsController::class)->group(function () {
    Route::middleware('auth:api')->delete('removemobilelicense/{mobileId}/{licenseId}','deleteMobileAdsLicense');
    Route::middleware('auth:api')->put('addmobileadslicense/{mobileId}','addMobileAdsLicense');
    Route::middleware('auth:api')->put('updateImagemontagemobile/{mobileId}', 'updateImageMontageMobile');
    Route::middleware('auth:api')->put('editmobileadslicense/{mobileId}', 'editMobileAdsLicense');
    Route::middleware('auth:api')->post('submiteditmobile/{mobileId}', 'submitEditMobile');
    Route::middleware('auth:api')->put('editbrandingname/{mobileId}','editBrandingName');
    Route::middleware('auth:adminapi')->post('adminedituser/{userid}', 'adminEditUser');
    Route::middleware('auth:adminapi')->post('editadminuser/{adminid}', 'editAdminUser');
    Route::middleware('auth:api')->post('edituserpassword', 'editUserPassword');
    Route::post('checkemailadmin', 'checkEmailAdmin');
    Route::post('checktokenupdate', 'checkTokenUpdate');
    Route::patch('changeadminpassword', 'changeAdminPassword');
});

Route::controller(\App\Http\Controllers\Api\EditAdsController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->delete('deletelicencebyadmin/{mobileId}/{licenseId}', 'deleteMobileAdsLicenceAdmin');
    Route::middleware(['auth:adminapi', 'last.login'])->put('addmobileadsbyadmin/{mobileId}','addMobileAdsLicense');
    Route::middleware(['auth:adminapi', 'last.login'])->put('updatemontagemobilebyadmin/{mobileId}','updateImageMontageMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->put('editmobileadslicensebyadmin/{mobileId}','editMobileAdsLicense');
    Route::middleware(['auth:adminapi', 'last.login'])->post('submiteditmobileuser/{mobileId}', 'submitEditMobile');
    Route::middleware(['auth:adminapi', 'last.login'])->put('editbrandnamemobile/{mobileId}','editBrandingName');
});

Route::controller(\App\Http\Controllers\Api\ReportController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('mobilepermitreport', 'mobilePermitReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('onpremisepermitreport', 'onpremisePermitReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('thridPartypermitreport', 'thridPartyPermitReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('thirdpartymobilepermitreport', 'thirdPartyMobilePermitReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('temporaryadsreport', 'temporaryadsReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('smallformatreport', 'smallFormatReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('streetlampreport', 'streetLampReport');
    Route::middleware('auth:api')->get('customerreport', 'customerReport');
    Route::middleware(['auth:adminapi', 'last.login'])->get('mobiledownloadcsv', 'mobiledownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('onpremisedownloadcsv', 'onpremisedownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('outdoordownloadcsv', 'outdoordownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('thirdpartymobiledownloadcsv', 'thirdpartymobiledownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('temporarydownloadcsv', 'temporarydownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('smallformatdownloadcsv', 'smallformatdownloadcsv');
    Route::middleware(['auth:adminapi', 'last.login'])->get('streetLampdownloadcsv', 'streetLampdownloadcsv');
});

Route::controller(\App\Http\Controllers\Api\KycThirdpartyController::class)->group(function () {
    Route::post('kycthirdparty', 'registerExpressionInterest');
    Route::get('getmyexpression/{thirdpartykycid}', 'getThirdPartyExpression');
    Route::post('editthirdpartykyc/{thirdpartykycid}/{editStatus}', 'editKycApplication');
    Route::get('getcertificate/{thirdpartykycid}', 'getMyThirdPartyCertificate');
});

Route::controller(App\Http\Controllers\Api\AdminKycThirdPartyController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('getallexpression', 'getAllThirdPartyExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getexpression/{thirdpartykycid}', 'getThirdPartyExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('operationapproval/{thirdpartykycid}', 'operationCertifyApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('operationdisapproval/{thirdpartykycid}', 'operationDecertifyApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legalscore/{thirdpartykycid}', 'legalScoreExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('accountscore/{thirdpartykycid}', 'accountScoreExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('registryscore/{thirdpartykycid}', 'registryScoreExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legaldisapproval/{thirdpartykycid}', 'legalDisapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('accountdisapproval/{thirdpartykycid}', 'accountDisapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('registrydisapproval/{thirdpartykycid}', 'registryDisapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapproval/{thirdpartykycid}', 'hodapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddisapproval/{thirdpartykycid}', 'hoddisapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdapproval/{thirdpartykycid}', 'mdapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mddisapproval/{thirdpartykycid}', 'mddisapprovalExpression');
    Route::middleware(['auth:adminapi', 'last.login'])->post('getthirdpartycertificate/{thirdpartykycid}', 'getThirdPartyCertifcate');
    Route::middleware('auth:api')->get('getkycformatdownloadables/{id}', 'getKycformatDownloadables');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getkycthirdpartypricing', 'getKycThirdPartyPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateKycthirdpartypricing/{id}', 'updateKycThirdPartyPricing');
});

Route::controller(App\Http\Controllers\Api\ThirdPartySignageController::class)->group(function () {
    Route::post('applyforoutdoorsignage', 'createOutdoorSignage');
    Route::post('secondphaseoutdoorsignage/{id}', 'secondPhaseOutdoorSignage');
    Route::get('getoneoutdoor/{outdoorid}', 'getOneofMyOutdoorSignage');
    Route::post('appealoutdoorsignage/{id}', 'appealOutdoorSignage');
    Route::post('editoutdoorapp/{outdoorid}', 'editOutdoorApplication');
    Route::post('editoutdoorappdetails/{outdoorid}', 'editOutdoorApplicationDetails');
    Route::post('outdoorsubmitbutton/{outdoorid}', 'submitEditButtonForOutdoorSignage');
    Route::post('outdoorsignagerequest/{id}', 'OutdoorSignageCostRequest');
    Route::post('outdoorupgradeanddowngrade/{id}', 'outdoorSignageUpgradeandDowngrade');
    Route::post('outdoortransferrequest/{id}', 'outdoorTransferSignageRequest');
    Route::post('acceptoutdoortransferrequest/{type}/{id}', 'acceptOutdoorTransferSignageRequest');
    Route::get('getthirdpartyuser', 'searchThirdPartyUser');
    Route::get('getallmyoutdoorsignage', 'getAllMyOutdoorSignage');
    Route::get('getallmytransferoutdoorsignage', 'getOutdoorTransferSignage');
    Route::get('test/{id}', 'testFunction');
});

Route::controller(App\Http\Controllers\Api\AdminThirdPartySignageController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('getalloutdoorapplication', 'getAllOutdoorSignage');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getoneoutdoorapplication/{outdoorid}', 'getOneOutdoorSignage');
    Route::middleware(['auth:adminapi', 'last.login'])->post('certifyoutdoor/{outdoorid}', 'certifyOutdoorApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('decertifyoutdoor/{outdoorid}', 'decertifyOutdoorApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('uploadsitereport/{outdoorid}','uploadSiteReportByRM');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodappoverecommend/{outdoorid}', 'hodApprovalRecommendation');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddisapproverecommend/{outdoorid}', 'hodDisapprovalRecommendation');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdfirstapproval/{outdoorid}', 'mdApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdfirstdisapproval/{outdoorid}', 'mdDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmsecondapproval/{outdoorid}', 'rmSecondStageDocReviewApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmseconddisapproval/{outdoorid}', 'rmSecondStageDocReviewDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodsecondapproval/{outdoorid}', 'hodSecondStageRecommendationApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodseconddisapproval/{outdoorid}', 'hodSecondStageRecommendationDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legaloutdoorapproval/{outdoorid}','legalRecommendationApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('legaloutdoordisapproval/{outdoorid}', 'legalRecommendationDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdsecondapproval/{outdoorid}', 'mdSecondApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdseconddisapproval/{outdoorid}', 'mdSecondDisApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('billingoutdoorgeneration/{outdoorid}', 'billGeneration');
    Route::middleware(['auth:adminapi', 'last.login'])->post('complianceapproval/{outdoorid}/{id}', 'complianceApprovedRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('accountapproval/{outdoorid}', 'accountApprovedRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmapprovedrequest/{outdoorid}/{id}', 'rmApprovedRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('compliancedisapproval/{outdoorid}/{id}', 'complianceDisapprovedRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapprovedrequest/{outdoorid}/{id}', 'hodApprovedRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddisapproverequest/{outdoorid}/{id}', 'hodDisapproveRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('outdoorreports/{outdoorid}/{id}','outdoorSiteReportforRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdapprovalforoffcharges/{outdoorid}/{id}', 'mdApprovalforRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mddisapprovalforoffcharges/{outdoorid}/{id}', 'mdDisapprovalforRequest');
    Route::middleware(['auth:adminapi', 'last.login'])->post('generateoffchargebill/{outdoorid}/{id}','generateNewOffChargeBill');
    Route::middleware(['auth:adminapi', 'last.login'])->post('setsiteinspection/{outdoorid}/{id}', 'setSiteInspectionStatus');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmassessment/{outdoorid}/{id}', 'assessmentReportByRM');
    Route::middleware(['auth:adminapi', 'last.login'])->post('houassessmentreport/{outdoorid}/{id}', 'assessmentReportByHOU');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodapprovalupgradeordowngrade/{outdoorid}/{id}', 'recommendUpgradeandDowngradeApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hoddisapprovalupgradeordowngrade/{outdoorid}/{id}', 'recommendUpgradeandDowngradeDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdapprovalupgradeordowngrade/{outdoorid}/{id}', 'mdUpgradeandDowngradeApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mddisapprovalupgradeordowngrade/{outdoorid}/{id}', 'mdUpgradeandDowngradeDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('billingforupgradeanddowngrade/{outdoorid}/{id}', 'billCalcforUpgradeandDowngrade');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodbillapproval/{outdoorid}/{id}', 'hodBillingApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodbilldisapproval/{outdoorid}/{id}', 'hodBillingDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post( 'hodregbillapproval/{outdoorid}/{id}', 'hodRegistryApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodregbilldisapproval/{outdoorid}/{id}', 'hodRegistryDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('sendupgradeanddowngradebill/{outdoorid}/{id}', 'sendBillAfterUpgradeorDowngrade');
    Route::middleware(['auth:adminapi', 'last.login'])->post('sendapprovalletter/{outdoorid}/{id}', 'sendUpgradeorDowngradeApprovalLetter');
    Route::middleware(['auth:adminapi', 'last.login'])->post('recommendsitetransferapproval/{outdoorid}/{id}', 'recommendforSiteTransferApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('recommendsitetransferdisapproval/{outdoorid}/{id}', 'recommendforSiteTransferDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodrecommendsitetransferapproval/{outdoorid}/{id}', 'hodrecommendforSiteTransferApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodrecommendsitetransferdisapproval/{outdoorid}/{id}', 'hodrecommendforSiteTransferDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdsitetransferapproval/{outdoorid}/{id}', 'mdSiteTransferApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdsitetransferdisapproval/{outdoorid}/{id}','mdSiteTransferDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('generatebilltransfer/{outdoorid}/{id}', 'generateTransferBill');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getoutdoorpricing', 'getOutdoorPricing');
    Route::get('getoutdoorpricingdistinct', 'getOutdoorPricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateoutdoorpricing/{id}', 'updateOutdoorPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createoutdoorpricing', 'createOutdoorPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deleteoutdoorpricing/{id}', 'deleteOutdoorPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getoutdoorpricingapplication', 'getOutdoorPricingApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updateoutdoorpricingapplication/{id}', 'updateOutdoorPricingApplication');
    Route::middleware('auth:api')->get('getoutdoordownloadables/{id}', 'getOutdoorDownloadables');
});

Route::controller(App\Http\Controllers\Api\FirstPartyTemporaryAdsController::class)->group(function () {
    Route::post('createfirstpartytemporaryads', 'createTemporaryAds');
    Route::get('getallmyfirstpartytemporaryads', 'getAllTemporaryAds');
    Route::get('getmyfirstpartytemporaryads/{id}', 'getOneTemporaryAds');
    Route::post('edittemporaryads/{id}','editTemporaryAds');
    Route::post('edittemporarydetails/{id}/{detailsId}', 'editTemporaryDetailsAds');
    Route::post('submiteditfirstpartytemporary/{id}','submitEditButtonFirstPartyTemporary');
});

Route::controller(App\Http\Controllers\Api\AdminFirstPartyTemporaryAdsController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetallfirstpartytemporrayads', 'adminGetAndSearchFirstPartyTemporaryAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetonefirstpartytemporaryads/{id}', 'getOneFirstPartyTemporaryAds');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmrecommendtemporaryadsapproval/{id}', 'rmRecommendTemporaryAdsApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('rmrecommendtemporaryadsdisapproval/{id}', 'rmRecommendTemporaryAdsDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodrecommendtemporaryadsapproval/{id}', 'hodRecommendTemporaryAdsApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('hodrecommendtemporaryadsdisapproval/{id}', 'hodrecommendTemporaryAdsDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdapprovaltemporaryads/{id}','mdApprovalTemporaryAds');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mddisapprovaltemporaryads/{id}', 'mdDisapprovalTemporaryAds');
    Route::middleware('auth:api')->get('gettemporarydownloadables/{id}', 'gettemporaryDownloadables');
    Route::middleware(['auth:adminapi', 'last.login'])->get('gettemporarypricing', 'getTemporaryPricing');
    Route::get('gettemporarypricingdistinct/{party}', 'getTemporaryPricingDistinct');
    Route::middleware(['auth:adminapi', 'last.login'])->get('gettemporaryapplicationpricing', 'getTemporaryApplicationPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->get('deletetemporarypricing/{id}', 'deleteTemporaryPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatetemporaryadspricing/{id}', 'updateTemporaryAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('createtemporaryadspricing', 'createTemporaryAdsPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatetemporaryadsapplicationpricing/{id}', 'updateTemporaryAdsApplicationPricing');
});

Route::controller(App\Http\Controllers\Api\SmallFormatController::class)->group(function () {
    Route::post('createsmallformatads','createSmallFormatAds');
    Route::get('getallsmallformatads', 'getAllSmallFormatAds');
    Route::get('getsmallformatad/{id}', 'getOneSmallFormatApplication');
    Route::get('getsmallformatdetails/{id}', 'getOneSmallFormatDetailsApplication');
    Route::middleware('auth:api')->get('getsmallformatdownloadables/{id}', 'getSmallformatDownloadables');
});

Route::controller(App\Http\Controllers\Api\AdminSmallFormatAdsController::class)->group(function () {
    Route::middleware(['auth:adminapi', 'last.login'])->get('adminsearchsmallformat', 'adminSearchSmallFormatAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetsmallformat/{id}','adminGetOneSmallFormatAds');
    Route::middleware(['auth:adminapi', 'last.login'])->get('admingetsmallformatdetails/{id}', 'adminGetOneSmallFormatDetails');
    Route::middleware(['auth:adminapi', 'last.login'])->post('adminsetinspectionfee/{id}', 'adminSetInspectionFee');
    Route::middleware(['auth:adminapi', 'last.login'])->post('admincertifyapplication/{smallId}/{id}', 'adminCertifyApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('admindecertifyapplication/{smallId}/{id}', 'adminDecertifyApplication');
    Route::middleware(['auth:adminapi', 'last.login'])->post('registryapprovesmallformat/{id}', 'registryHeadApproveRecommendation');
    Route::middleware(['auth:adminapi', 'last.login'])->post('registrydisapprovesmallformat/{id}', 'registryHeadDisapprovalRecommendation');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdsmallformatdetailsapproval/{id}', 'mdSmallFormatDetailsApproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('mdsmallformatdetailsdisapproval/{id}', 'mdSmallFormatDetailsDisapproval');
    Route::middleware(['auth:adminapi', 'last.login'])->post('billinggeneratesmallformat/{id}', 'billingsDeptGenerateInvoice');
    Route::middleware(['auth:adminapi', 'last.login'])->get('getsmallformatapplicationpricing', 'getSmallFormatApplicationPricing');
    Route::middleware(['auth:adminapi', 'last.login'])->post('updatesmallformatapplicationpricing/{id}', 'updateSmallFormatApplicationPricing');
});

