<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!--<title>Bill/Invoice for 2536272</title>-->

    <style>
      body {
        margin: 0;
        padding: 0;
        line-height: 1.6;
      }
      .container {
        max-width: 907px;
        margin: 20px auto;
        padding: 5px 10px;
        border: 1.5px solid #3889a6;
      }
      h1 {
        text-align: center;
        margin-bottom: 20px;
      }
      p {
        margin-bottom: 15px;
      }
      .image-container {
        text-align: center;
      }
      .image-container img {
        max-width: 100%;
        width: 150px;
        height: auto;
      }

      a {
        text-decoration: none;
        color: #000;
      }

      .costList {
        max-width: 730px;
        margin: 20px auto;
      }

      .costList table {
        font-size: 14px;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        width: 100%;
      }

      .costList thead {
        background: rgb(7, 119, 159);
        background: linear-gradient(
          0deg,
          rgba(7, 119, 159, 1) 0%,
          rgba(22, 164, 212, 1) 100%
        );
        border-bottom: 1.5px solid #0a526c;
      }

      .costList table th {
        padding: 2.5px;
        color: #fff;
        text-align: start;
      }

      .costList table th:first-child {
        border-left: solid 1.5px #3889a6;
      }

      .costList table th:last-child {
        border-right: solid 1.5px #3889a6;
      }

      .costList table th:not(:last-child) {
        border-right: 1.5px solid #fff;
      }

      .costList tbody {
        border: solid 1.5px #3889a6;
      }

      .costList tbody td {
        text-align: start;
        padding: 6px 2.5px;
        vertical-align: middle;
      }

      .costList tbody tr:nth-child(even) {
        background-color: #f1f9fc;
      }
    </style>
  </head>

  <body>
    <div class="container">
      <div class="image-container">
        <img src="lasaa-web-logo.png" alt="" />
      </div>

      <p style="display: inline-block;">{{ $data['date'] }}</p>

      <div style="float:right;">
        <img style="width: 200px; height: auto;" src="barCode.png" alt="">
        <span style="display: block; font-size: 20px;">{{ $data['barcode'] }}</span>
      </div>

      <p>
        <strong>The Managing Director/CEO</strong> <br />
        {{ $data['company'] }}, <br />
        {{ $data['address'] }}.
      </p>

      <p>Dear Sir/Madam</p>

      <p style="text-decoration: underline">
        <strong>APPROVAL FOR FIRST PARTY SIGNAGE DISPLAY</strong>
      </p>

      <p>We hereby acknowledge receipt of your Application Form.</p>
      <p>
        We are pleased to inform you that having undergone the process chain of
        the Agency and passed the Agency's scrutiny stage; your company is
        hereby qualified to deploy the signage approved by the Agency.
      </p>
    </div>

    <div class="costList">
      <table>
        <thead>
          <tr>
            <th>Signage</th>
            <th>Site Location</th>
            <th>Size Category</th>
          </tr>
        </thead>
        <tbody>
            @foreach($combinedArray as $item)
          <tr>
            <td>{{$item['key']}}</td>
            <td>{{ $data['address'] }}</td>
            <td>Up to {{$item['value']}}sqm</td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>

    <div class="container">
      <p>
        Please note that the bill for the annual permit fee will commence on {{ $data['startDate'] }} and expires {{ $data['endDate'] }} while for subsequent years
        will read 1st January and end 31st of December.  @if ($data['prev'] > 0) Also note that the total due includes an arrers. @endif
      </p>
      
      <p>
        {{ $data['comment'] }}
      </p>

      <p>
        However, please be informed that it is pertinent you disclose all signs
        and advertising materials relating to your premises as undisclosed
        Structures/Sizes will be deemed illegal and your organization would be
        penalized.
      </p>

      <p>
        You are required to make payment without delay. Failure to make payment
        within (2) weeks upon receipt of this notice will lead to the revocation
        of this approval.
      </p>

      <p>Thank you for your cooperation in this regard.</p>

      <p>Yours faithfully</p>

      <!--<div>-->
      <!--  <img src="MD-SIGNATURE.png" alt="" />-->
      <!--</div>-->

      <p>
         {{ $data['HOD_last_name'] }} {{ $data['HOD_first_name'] }} <br />
        <strong>Head, {{ $data['zone'] }} </strong> <br />
        <strong>For: MD/CEO, LASAA</strong>
      </p>

      <p style="text-align: center; border-bottom: 1.5px solid #000">
        Lagos State Signage & Advertisement Agency
      </p>

      <p style="text-align: center">
        Eleganza Plaza, 33, Mobolaji Johnson Avenue, Ikeja, Lagos <br />
        <a href="tel:+2349088019303">Tel: +234 908 801 9303</a>
        <a href="mailto:info@lasaa.com">Email: info@lasaa.com</a>
        <a href="www.lasaa.com">Website: www.lasaa.com</a>
      </p>
    </div>
  </body>
</html>
