<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Document</title>
  </head>

  <body>
    <section>
      <style>
          body::before {
              content: ' ';
              position: fixed;
              top: 0;
              right: 0;
              bottom: 0;
              left: 0;
              background: url("lasaa-web-logo.png");
              opacity: 0.1;
              pointer-events: none;
          }
          footer {
              position: relative;
              width: 100%;
              background-color: #333333;
          }
          p.copyright {
              position: absolute;
              width: 100%;
              color: #fff;
              line-height: 40px;
              font-size: 0.7em;
              text-align: center;
              bottom: 0;
          }
        section {
          max-width: 720px;
          margin: 0 auto;
        }

        .table-container {
          border: gray 2px solid;
        }

        .table-container h4 {
          border: gray 2px solid;
          margin: 0;
          background: #6fc0fa;
          padding: 20px 10px;
        }

        .table-container table {
          width: 100%;
          background-color: gray;
          border: none;
        }

        .table-container table th,
        .table-container table td {
          margin: 0;
          background: #fff;
          padding: 10px;
          text-align: left;
        }

        p {
          font-size: large;
        }

        .address table {
          width: 100%;
        }

        .address p {
          max-width: 300px;
          line-height: 1.25rem;
          margin: 10px 0;
        }

        .center *{
            text-align: center;
            line-height: 1rem;
            margin: 6px 0;
        }
        .center h4{
            font-size: x-large;
        }
        .mainT{
            font-size: x-large;
            margin: 5px 0;
        }
        .yours *{
            margin: 0;
        }
        .closing {
            border-top: gray 2px solid;
            margin-top: 50px;
            font-size: small;
        }

        img.logo{
            display: block;
            margin: 0px auto;
            padding: 40px 0;
        }
        section{
            position: relative;
        }
        section::after {
            content: "";
            position: absolute;
            opacity: 10%;
            height: 100%;
            width: 100%;
            top: 0;
            left: 0;
            background-image: url(/lasaa-web-logo.png);
            background-repeat: no-repeat;
            background-position: center center;
            background-size: contain;
        }
      </style>
      <div>
        <img src="lasaa-web-logo.png" alt="" class="logo">
      </div>
      <div class="address">
        <table>
          <tr>
            <td>
                <p>{{ $data['startdate'] }}</p>
            </td>
            <td>
{{--              <p>Ref No: 230809/SLP/ETO/005</p>--}}
                <p><b>Ref No</b>: {{ $data['refNo'] }}</p>
            </td>
          </tr>
          <tr>

                <p><b>{{ $data['businessname'] }}</b></p>
                <p><b>{{ $data['address'] }}</b></p>
            </td>
          </tr>
        </table>
      </div>

      <div>
        <p>Dear Sir/ Madam,</p>
        <h4 class="mainT">
          APPROVAL/PERMIT FOR TEMPORARY DISPLAY OF STREET LAMP POLE
          ADVERTISEMENT
        </h4>
        <p>
          The Agency is pleased to grant you temporary permit for {{ $data['poleinWord'] }}
          ({{ $data['totalPole'] }}) street lamp poles to be used for advertisement and placed along
            @foreach($combinedArray as $item)
          <b>{{ $item['key']  }}, </b>
            @endforeach
            in line with the information on your application form.
        </p>
        <div class="table-container">
          <h4>Sign Information</h4>
          <table>
            <thead>
              <th>Sign Display ID</th>
              <th>Sign Type Name</th>
              <th>Sign Width</th>
              <th>Sign Height</th>
              <th>Size (Sqm)</th>
              <th>Proposed Duration</th>
              <th>No Of Poles</th>
            </thead>
            <tbody>
            @foreach($combinedArray as $item)
              <tr>
                <td>{{ $data['refNo']  }}</td>
                <td>Street Lamp Pole</td>
                <td> {{ $item['value'] }}</td>
                <td>{{ $item['extra'] }}</td>
                <td>{{ $data['size'] }}</td>
                <td> {{ $data['duration'] }}</td>
                <td>{{ $item['poles'] }}</td>
              </tr>
            @endforeach
            </tbody>
          </table>
        </div>

        <p>
          Your permit is valid for the duration of
{{--          <b>(1st January – 31st December, 2024)</b>--}}
             <b>{{ $data['startdate'] }} - {{ $data['duration'] }}</b>
        </p>
        <p>
          At the end of this period, you will be expected to discontinue the
          display failing which, such action will be considered illegal and
          appropriate legal action will ensue
        </p>
      </div>

      <div class="center">
        <p>**please see overleaf**</p>
      </div>

      <div>
        <p>
          In case a renewal/extension of this approval after expiration is
          expressed, kindly ensure you re-apply one month before expiration of
          this approval. If an application is not received by the end of the
          expiration period, this would be taken as an indication that you are
          no longer interested in the site and the site will be re-allocated to
          other interested clients.
        </p>
        <p>Thank you for your cooperation.</p>
        <p>Yours faithfully,</p>
      </div>

      <div class="yours">
          <img src="MD-SIGNATURE.png" alt="MD signature">
        <p>Prince Fatiu Akiolu</p>
        <p><b>Managing Director/CEO.</b></p>
      </div>
        <p>
        <b>{{$data['refNo']}} </b> &nbsp;    &nbsp;   <b> {{ $data['refNo'] }}  </b>   &nbsp;          &nbsp;  <b>     {{$data['refNo']}}  </b>   &nbsp; &nbsp;
        </p>

      <div class="closing">
        <h5>NOTE THAT:</h5>
        <ul>
          <li>
            All rights to sites allocated shall revert to the Agency upon the
            expiration of the 1-year term which runs from 1st Jan – 31st Dec.
          </li>
          <li>
            The Client must ensure that lamp poles are in conformity with the
            approval obtained. Failure to comply shall lead to revocation.
          </li>
          <li>
            All Expression of Interest must be submitted before the
            expiration/end of every year and the Agency reserves the right to
            reject, revoke or modify any request for renewal of approval.
          </li>
          <li>
            The Client shall indemnify the Agency from any claims, liabilities,
            damages, or expenses arising out of or in connection with the event,
            including but not limited to personal injury, property damage, or
            breach of any applicable laws or regulations.
          </li>
          <li>
            The Agency shall not lose its regulatory rights as a result of
            inaction on any Client’s default
          </li>
          <li>
            Agency shall allocate street lamp poles as deemed fit and
            Practitioners must strictly followed the Street Lamp Poles Policy
            without default.
          </li>
          <li>
            Please note that Indebtedness and lack of expression of interest are
            automatic grounds for disqualification
          </li>
        </ul>
      </div>
        <footer>
            <p class="copyright">&copy; LASAA {{ \Carbon\Carbon::now()->year }}</p>
        </footer>
    </section>

  </body>
</html>
