<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f9f9f9;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
            background-color: #ffffff;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header img {
            max-width: 100%;
            height: auto;
        }
        .date-ref {
            text-align: right;
            margin-bottom: 20px;
        }
        .content {
            margin-bottom: 20px;
        }
        .content p {
            margin: 0 0 10px;
        }
        .signature {
            margin-top: 30px;
        }
        .signature p {
            margin: 0;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <img src="lasaa-web-logo.png" alt="LASAA Logo">
    </div>
    <div class="date-ref">
        <p>{{ $data['date'] }}</p>
        <p></p>
    </div>
    <div class="content">
        <p>{{ $data['userinfo'] }}<br>
        {{ $data['useraddress'] }}<br>
        {{ $data['bustop'] }}<br>
        {{ $data['lga'] }}</p>
        <br>
        <p>Dear Sir/Ma,</p>
        <br>
        <p style="text-align: center;"><strong>TEMPORARY PERMIT NO: {{ $data['permitNumber'] }}</strong></p>
        <br>
        <p>We are pleased to inform you that based on your application, your organization is hereby granted a
            <b>"Premium Category Temporary Blanket Permit"</b> for Sales Activations; which will be used for <b>{{ $data['nameAds'] }} products ONLY</b>.</p>
        <p>Your permit is valid for @if($data['monthvalidity'] == 12) One (1) Calendar Year  @else {{ $data['monthsvalidityInWords'] }} ({{ $data['monthvalidity'] }}) Month(s) @endif: {{ $data['startdate'] }} to {{ $data['enddate'] }}.</p>
        <p>This permit affords your organization the opportunity to display the following for the @if($data['monthvalidity'] == 12) One (1) Calendar Year  @else {{ $data['monthsvalidityInWords'] }} ({{ $data['monthvalidity'] }}) Month(s) @endif stated above, subject to conditions listed on the reverse side of this letter:</p>
        <ul>
            <li>Carry out Sales Activations/Advertisement as often as your organization may wish for @if($data['monthvalidity'] == 12) One (1) Calendar Year  @else {{ $data['monthsvalidityInWords'] }} ({{ $data['monthvalidity'] }}) Month(s) @endif without having recourse to the Agency for registration/permission.</li>
            <li>Display unlimited number of branded T-Shirts</li>
            <li>Display unlimited number of banners and posters attached to vehicles.</li>
            <li>Display unlimited number of branding/banners on the rigs.</li>
            <li> Display unlimited number of feather banners.</li>
            <li>Make use of unlimited city walkers (STATIC ONLY).</li>
            <li>Make use of unlimited Push Carts.</li>
            <li>Point of Sale (POS)</li>
            <li>Character Balloons</li>
        </ul>
        <p>Kindly note that in the event of the display of unapproved materials, your organization will be issued with a stiff penalty. Also, failure to adhere to this will be considered illegal and appropriate legal action will ensue.</p>
        <p>Thank you as we appreciate your patronage and compliance with the law.</p>
        <br>
        <p>Yours faithfully,</p>
    </div>
        <div class="signature">
            <p>Olubukonla Ayodele</p>
            <p>Head, Mobile Advert Department</p>
            <p>For: Managing Director/CEO</p>
        </div>
        <br>
        <br>
        <br>
        <br>
        <br>
        <br>
    <div class="content" style="color:red;">
        <p><b>Conditions of Approval:</b></p>
        <p>Please note that this "Premium Category Temporary Blanket Permit:</p>
        <ul>
            <li>Branded {{ $data['nameAds'] }} vehicles (to be registered under 1st Party Mobile Advert).</li>
            <li>Non-{{ $data['nameAds'] }} Products.</li>
            <li>No Temporary L.E.D.</li>
            <Li>No PAV (Promotional Advert Vehicle).</Li>
            <li>No Road Shows on any bridge.</li>
            <li>Noise Pollution permit must be obtained from relevant Government Agency.</li>
        </ul>
    </div>
</body>
</html>
