<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Registration Cert</title>

    <style>
        @font-face {
            font-family: "Montserrat";
            font-style: normal;
            font-weight: 400;
            src: url("./font/Montserrat-Regular.ttf");
        }
        @font-face {
            font-family: "Montserrat";
            font-style: normal;
            font-weight: 500;
            src: url("./font/Montserrat-Medium.ttf");
        }
        @font-face {
            font-family: "Montserrat";
            font-style: normal;
            font-weight: 600;
            src: url("./font/Montserrat-SemiBold.ttf");
        }
        * {
            /* box-sizing: border-box; */
            text-align: center;
            letter-spacing: 2.4px;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: "Montserrat", sans-serif;
            margin: 0;
            padding: 0;
            /* line-height: 1.6; */
        }

        .container {
            width: 707px;
            height: 1000px;
            margin: 20px auto;
            background : url("new.png");
            background-repeat: no-repeat;
            background-position: top;
            background-size: contain;
        }

        .contentHolder {
            height: 100%;
            /* width: fit-content; */
            margin: 00px 60px;
        }

        .certNo {
            padding-top: 200px;
            margin-bottom: 20px;
        }

        .certNo span {
            font-size: 24px;
        }

        .certNo .title {
            font-weight: 600;
        }

        .certNo .serialNo {
            font-weight: 500;
            color: rgb(221, 8, 8);
        }

        .CertName h1 {
            font-size: 45px;
            font-weight: 500;
            letter-spacing: 8px;
            margin-bottom: 10px;
        }

        .CertName p {
            font-size: 20px;
            font-weight: 500;
            letter-spacing: 8px;
        }

        .testament {
            margin: 24px 0;
            font-size: 18px;
        }

        .companyName {
            color: rgb(221, 8, 8);
            text-transform: uppercase;
            margin-top: 40px;
            border-bottom: 2px rgb(221, 8, 8) solid;
            padding-bottom: 10px;
        }

        .certDetails {
            margin-top: 30px;
            font-size: 17px;
            font-weight: 500;
            line-height: 1.3;
        }

        .codeDate {
            display: inline-block;
            margin-top: 28px;
        }

        .codeHolder {
            width: 80px;
            height: 80px;
            margin-right: 20px;
            display: inline-block;
        }

        .codeHolder img {
            width: 100%;
            height: auto;
        }

        .dateHolder {
            display: inline-block;
        }

        .singleDate {
            display: block;
            text-align: start;
            height: 40px;
        }

        .singleDate span {
            font-size: 18px;
            font-weight: 600;
        }

        .singleDate .title {
            color: rgb(221, 8, 8);
        }

        .signature {
            margin-top: 50px;
            width: 300px;
        }

        .signature img {
            width: 150px;
            display: block;
            margin: auto;
            padding-bottom: 10px;
        }

        .signature p {
            letter-spacing: normal;
        }

        .signature .name {
            font-weight: 600;
            font-size: 18px;
        }
    </style>
  </head>
  <body>
    <div class="container">
      <div class="contentHolder">
        <div class="certNo">
          <span class="title">REG NO:</span>
          <span class="serialNo">{{ $data['refno'] }}</span>
        </div>

        <div class="CertName">
          <h1>CERTIFICATE</h1>
          <p>OF REGISTRATION</p>
        </div>

        <p class="testament">This certifies that</p>

        <h1 class="companyName">{{ $data['companyName'] }}</h1>

        <p class="certDetails">
          has successfully completed the registration process as an Out-of-Home
          (OOH) Practitioner in Lagos State, demonstrating proficiency in OOH
          advertising principles and practices, enriching the advertising
          landscape of Lagos State.
        </p>

        <div class="codeDate">
{{--          <div class="codeHolder">--}}
{{--            <img src="sized.png" alt="Lasaa qrcode" />--}}
{{--          </div>--}}
          <div class="dateHolder">
            <div class="singleDate">
              <span class="title">Issued Date</span>
              <span class="info">{{ $data['date'] }}</span>
            </div>
            <div class="singleDate">
              <span class="title">Expiry Date</span>
              <span class="info">{{ $data['endDate'] }}</span>
            </div>
          </div>
        </div>

        <div class="signature">
          <img src="MD-SIGNATURE.png" alt="" />
          <p class="name">Prince Fatiu Akiolu</p>
          <p class="title">Managing Director/CEO</p>
        </div>
      </div>
    </div>
  </body>
</html>
