<?php

namespace App\Models;

use App\Http\Middleware\Authenticate;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class UserAdmin extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'user_admin';

    protected $fillable = [
       'first_name',
       'last_name',
        'email',
        'phone-number',
        'password',
        'lga',
        'department',
        'zone',
        'zone2'
    ];

    protected $hidden = [
        'password'
    ];

    public function adminRole() {
        return $this->belongsTo(AdminRole::class);
    }

    public function adminActivity() {
        return $this->hasMany(AdminActivity::class);
    }
}
