<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ThirdPartyOutdoorSignDetails extends Model
{
    use HasFactory;

    protected $table = 'thirdparty_outdoor_sign_details';
    protected $fillable = [
        'dimension_sign',
        'height_structure',
        'length_sign',
        'breadth_sign',
        'setback_distance',
        'signage_format',
        'number_faces',
        'sign_illumination',
        'sign_interaction',
        'photomontage',
        'structural_drawing',
        'location_map',
        'eia'
    ];

    protected $casts = [
        'ads_price' => 'double',
        'legal_fee' => 'double',
        'annual_adsprice_fee' => 'double',
        'annual_legal_fee' => 'double',
        'ads_price_pyears' => 'double',
        'legal_fee_pyears' => 'double',
        'ads_price_current_year' => 'double',
        'legal_fee_current_year' => 'double'
    ];

    public function thirdPartyOutdoor() {
        return $this->belongsTo(ThirdPartyOutdoor::class);
    }
}
