<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ThirdPartyOutdoor extends Model
{
    use HasFactory;


    protected $table = 'thirdparty_outdoor';
    protected $fillable = [
        'purpose_application',
        'type_sign',
        'payment_id',
        'address_proposed_site',
        'lga',
        'latitude',
        'longitude',
        'north',
        'east',
        'property_owner_name',
        'property_owner_signature',
        'property_owner_phone',
        'property_owner_email',
        'property_owner_consent',
        'first_permit_pay',
        'permit_year',
        'installation_date',
        'inspection_date',
        'rm_comment1',
        'rm_comment2',
        'hod_comment1',
        'hod_comment2',
        'legal_comment',
        'account_comment',
        'md_comment',
        'application_id'
    ];

    protected $casts = [
        'bill_generated' => 'boolean',
        'assigned_officer' => 'integer',
        'first_permit_pay' => 'boolean'
    ];


    public function user() {
        return $this->belongsTo(User::class);
    }

    public function thirdPartyOutdoorSignDetails() {
        return $this->hasOne(ThirdPartyOutdoorSignDetails::class);
    }

    public function appHistoryThirdPartyOutdoor() {
        return $this->hasMany(AppHistoryThirdPartyOutdoor::class);
    }

    public function paymentThirdPartyOutdoorSignage() {
        return $this->hasMany(PaymentThirdPartyOutdoorSignage::class);
    }

    public function permitStepOutdoor() {
        return $this->hasMany(PermitStepOutdoor::class);
    }

    public function thirdPartyOffChargeAndExpunction() {
        return $this->hasMany(ThirdPartyOffchargeAndExpunction::class);
    }

    public function  thirdPartyUpgradeAndDowngrade() {
        return $this->hasMany(ThirdPartyUpgradeAndDowngrade::class);
    }

    public function thirdPartyOutdoorTransfer() {
        return $this->hasMany(ThirdPartyOutdoorTransfer::class);
    }
    
    public function thirdpartyreceipts() {
        return $this->hasMany(ThirdPartyReceipts::class);
    }

}
