<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ThirdPartyMobileAdsPricing extends Model
{
    use HasFactory;

    protected $table = 'thirdpatry_mobile_ads_pricing';
    
    protected $fillable = [
        'vehicle_type',
        'annual_price',
        'monthly_price',
        'quarterly_price',
        'biannual_price',
        'daily_calculation_basis'
    ];

    protected $casts = [
        'daily_calculation_basis' => 'boolean',
        'annual_price' => 'double',
        'monthly_price' => 'double',
        'quarterly_price' => 'double',
        'biannual_price' => 'double'
    ];
}