<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StreetLampsAds extends Model
{
    use HasFactory;

    protected $table = 'street_lamp_ads';

    protected $fillable =  [
        'lga',
        'payment_id',
        'material_for_deployment',
        'duration' ,
        'source_of_electricity',
        'location_of_generator',
        'authorization_letter_lseb',
        'start_date'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function appHistoryStreetLamp() {
        return $this->hasOne(AppHistoryStreetLamp::class);
    }

    public function permitStepStreetLamp() {
        return $this->hasMany(PermitStepStreetLamp::class);
    }

    public function paymentStreetLamp() {
        return $this->hasOne(paymentStreetLamp::class);
    }

    public function streetLampInfo() {
        return $this->hasMany(StreetLampInfo::class);
    }
}
