<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentThirdPartyOutdoorSignage extends Model
{
    use HasFactory;

    protected $table = 'payment_thirdparty_outdoor';

    protected $fillable = [
        'application_purpose',
        'amount_paid',
        'status',
        'payment_type'
    ];

    protected $casts = [
        'amount_paid' => 'double'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function thirdPartyOutdoor() {
        return $this->belongsTo(ThirdPartyOutdoor::class);
    }
}
