<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentSmallFormatAds extends Model
{
    use HasFactory;

    protected $table = 'payment_small_format_ads';
    protected $fillable = [
       'application_purpose',
        'amount_paid',
        'status',
        'reference_id',
        'payment_id',
        'payment_type'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function smallFormatAds() {
        return $this->belongsTo(SmallFormatAds::class);
    }
}
