<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentOnPremise extends Model
{
    use HasFactory;

    protected $table = 'payment_onpremise';

    protected $fillable = [
       'application_purpose',
        'amount_paid',
        'status',
        'payment_type'
    ];

    protected $casts = [
        'amount_paid' => 'double'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function onpremise() {
        return $this->belongsTo(onpremise::class);
    }
}
