<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentFirstPartyTemporaryAds extends Model
{
    use HasFactory;

    protected $table = 'payment_first_party_temporary_ads';

    protected $fillable = [
        'application_purpose',
        'amount_paid',
        'status',
        'reference_id',
        'payment_id',
        'payment_type'
    ];

    protected $casts = [

    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function firstPartyTemporaryAds() {
        return $this->belongsTo(FirstPartyTemporaryAds::class);
    }
}
