<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OutdoorSignagePricing extends Model
{
    use HasFactory;
    
    protected $table = 'outdoor_signage_pricing';
    
    protected $fillable = [
        'designation', 
        'street_category', 
        'dimension_min', 
        'dimension_max', 
        'base_rate',
        'multiplier',
        'calculation_type'
    ];
    
    protected $casts = [
        'base_rate' => 'double'
    ];
}