<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnPremisePricingRule extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'onpremise_pricing_rule';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'street_category',
        'sign_type',
        'min_square_meter',
        'max_square_meter',
        'price_per_sqm',
        'is_bank_other_price',
        'duration'
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'min_square_meter'    => 'double',
        'max_square_meter'    => 'double',
        'price_per_sqm'       => 'double',
        'is_bank_other_price' => 'boolean',
    ];
}