<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class KycThirdPartyScore extends Model
{
    use HasFactory;

    protected $table = 'kyc_thirdparty_score';

    protected $fillable = [
        'arcon_score',
        'cac_score',
        'company_profile_score',
        'return_capital',
        'current_asset_ratio',
        'acid_test_ratio',
        'earning_share',
        'asset_ratio',
        'evidence_finance',
        'tax_clearance_score',
        'business_plan_score',
        'reference_letter_score',
        'bank_statement',
        'kyc_third_party_id',
        'registry_company_profile',
        'maintainance_plan',
        'pastproject_score',
        'preliminary_score',
        'design_innovation_score',
        'company_info_score'
    ];

    protected $casts = [
        'arcon_score' => 'double',
        'cac_score' => 'double',
        'company_profile_score' => 'double',
        'return_capital' => 'double',
        'current_asset_ratio' => 'double',
        'acid_test_ratio' => 'double',
        'earning_share' => 'double',
        'asset_ratio' => 'double',
        'evidence_finance' => 'double',
        'tax_clearance_score' => 'double',
        'business_plan_score' => 'double',
        'reference_letter_score' => 'double',
        'bank_statement' => 'double',
        'kyc_third_party_id' => 'double',
        'registry_company_profile' => 'double',
        'maintainance_plan' => 'double',
        'pastproject_score' => 'double',
        'preliminary_score' => 'double',
        'design_innovation_score' => 'double',
        'company_info_score' => 'double'
    ];

    public function kycThirdParty() {
        return $this->belongsTo(KycThirdParty::class);
    }
}
