<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KycThirdParty extends Model
{
    use HasFactory;

    protected $table = 'kyc_thirdparty';

    protected $fillable = [
       'company_name',
        'nearest_bustop',
        'lga',
        'employee_count',
        'office_address',
        'company_profile',
        'cac_document',
        'apcon_document',
        'outdoor_association',
        'audit_report',
        'list_past_project',
        'tax_clearance',
        'evidence_finance',
        'business_plan',
        'director_bank_statement',
        'preliminary_technical_design',
        'bank_or_corporate_reference',
        'technical_reference',
        'assigned_officer'
    ];

    protected $casts = [
       'legal_score' => 'double',
       'account_score' =>'double',
       'registry_score'=>'double',
        'kyc_active' => 'boolean'
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function kycThirdPartyPayment() {
        return $this->hasMany(KycThirdPartyPayment::class);
    }

    public function kycThirdPartyScore() {
        return $this->hasOne(KycThirdPartyScore::class);
    }
    
    public function kycthirdpartyreceipts() {
        return $this->hasMany(KycThirdpartyReceipts::class);
    }
}
