<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FirstPartyTemporaryAdsDetails extends Model
{
    use HasFactory;

    protected $table = 'first_party_temporary_details';

    protected $fillable = [
        'class_signs',
        'type_sign',
        'size_ads',
        'photo_montage',
        'number_of_days',
        'days_in_duration',
        'transit_sign',
        'wearable_sign',
        'moveable_animation'
    ];

    protected $casts = [
        'transit_sign' => 'boolean',
        'wearable_sign' => 'boolean',
        'moveable_animation' => 'boolean'
    ];

    public function firstPartyTemporaryAds() {
        return $this->belongsTo(FirstPartyTemporaryAds::class);
    }
}
