<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppHistoryThirdPartyOutdoor extends Model
{
    use HasFactory;

    protected $table = 'app_history_outdoor';
    protected $fillable = [
        'purpose_application',
        'who_performed_action',
        'comments',
        'reports_from_branchmanager',
        'report_file',
        'ads_price',
        'application_price'
    ];

    protected $casts = [
        'balance' => 'double',
        'ads_price' => 'double',
        'legal_fee' => 'double',
        'price_rate' => 'double'
    ];

    public function thirdPartyOutdoor() {
        return $this->belongsTo(ThirdPartyOutdoor::class);
    }
}
