<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppHistorySmallFormatDetails extends Model
{
    use HasFactory;

    protected $table = 'app_history_small_format_details';

    protected $fillable = [
       'purpose_application',
        'who_performed_action',
        'comments',
        'reports_from_branchmanager',
        'ads_price',
        'annual_adsprice',
        'balance',
        'payment_counter'
    ];

    protected $casts = [
        'ads_price' => 'double',
        'annual_adsprice' => 'double',
        'balance' => 'double',
        'payment_counter' => 'integer'
    ];

    public function smallFormatDetails() {
        return $this->belongsTo(SmallFormatDetails::class);
    }
}
