<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class PayStackMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $allowedIp  = [
            '52.31.139.75',
            '52.49.173.169',
            '52.214.14.220'
        ];

        $clientIp =  $request->ip();

        if(!in_array($clientIp, $allowedIp)) {
            return response($clientIp, 403);
        }

        return $next($request);
    }
}
