<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\mobilead;
use App\Models\onpremise;
use App\Models\StreetLampsAds;
use App\Models\ThirdPartyMobile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserAdsApplicationController extends Controller
{
    //

    public function __construct() {
        $this->middleware('auth:api');
    }

    public function getUserOnpremiseAds(Request $request) {

        $page = $request->input('per_page', 10);
        $userid = Auth::user()->id;
        $onpremise = onpremise::where('user_id', $userid)->orderBy('updated_at', 'DESC');
        if(count($onpremise->get()) == 0) {
            return response()->json(['data' => "User does not have onpremise ads application"], 422);
        } else {
            if($request->input('status')) {
                $status = $request->input('status');
                $onpremise->where(function ($onpremise) use($status) {
                    $onpremise->where('status', $status);
                });
            }
            $items = $onpremise->paginate($page);
            if($request->input('status')) {
                $items->appends(['status' => $request->input('status')]);
            }
            return response()->json(['data' => $items], 200);
        }
    }

    public function getUserMobileAds(Request $request) {

        $page = $request->input('per_page', 10);
        $userid = Auth::user()->id;
        $mobileAds = mobilead::where('user_id', $userid)->orderBy('updated_at', 'DESC');
        if (count($mobileAds->get()) == 0) {
            return response()->json(['data' => "User does not have mobile ads application"], 422);
        } else {
            if ($request->input('status')) {
                $status = $request->input('status');
                $mobileAds->where(function ($mobileAds) use($status) {
                    $mobileAds->where('status', $status);
                });
            }
            $items = $mobileAds->paginate($page);
            if($request->input('status')) {
                $items->appends(['status' => $request->input('status')]);
            }
            return response()->json(['data' => $items], 200);
        }
    }

    public function getUserStreetLampsAds(Request $request) {

        $page = $request->input('per_page', 10);
        $userid = Auth::user()->id;
        $streetLamp = StreetLampsAds::where('user_id', $userid)->orderBy('updated_at', 'DESC');
        if(count($streetLamp->get()) == 0) {
            return response()->json(['data' => "User does not have street Lamp ads application"], 422);
        } else {
            if ($request->input('status')) {
                $status = $request->input('status');
                $streetLamp->where(function ($streetLamp) use($status) {
                    $streetLamp->where('status', $status);
                });
            }
            $items = $streetLamp->paginate($page);
            if($request->input('status')) {
                $items->appends(['status' => $request->input('status')]);
            }
            return response()->json(['data' => $items], 200);
        }
    }

    public function getUserThirdPartyAds(Request $request) {

        $page = $request->input('per_page', 10);
        $userid = Auth::user()->id;
        $thirdPartyAds = ThirdPartyMobile::where('user_id', $userid)->orderBy('updated_at', 'DESC');
        if(count($thirdPartyAds->get()) == 0) {
            return response()->json(['data' => "User does not have third party mobile ads application"], 422);
        } else {
            if ($request->input('status')) {
                $status = $request->input('status');
                $thirdPartyAds->where(function ($thirdPartyAds) use($status) {
                    $thirdPartyAds->where('status', $status);
                });
            }
            $items = $thirdPartyAds->paginate($page);
            if($request->input('status')) {
                $items->appends(['status' => $request->input('status')]);
            }
            return response()->json(['data' => $items], 200);
        }
    }
}
