<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AdminActivity;
use App\Models\AdminRole;
use App\Models\mobilead;
use App\Models\MobileAdsVehicleLicense;
use App\Models\onpremise;
use App\Models\PermitStepMobile;
use App\Models\PermitStepOnpremise;
use App\Models\PermitStepStreetLamp;
use App\Models\StreetLampsAds;
use App\Models\ThirdPartyMobile;
use App\Models\ThirdPartyMobilePermitStep;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class LegalApprovalController extends Controller {

    public function legalApprovalForMobile($mobileId) {

        if(Auth::user()->admin_role_id == 9) {

            $setLegalApproval = mobilead::where('id', $mobileId)->update(['legal_status' => 'approved', 'final_status' => 'approved']);
            $getMobileAds = mobilead::where('id', $mobileId)->get();
            $mobileObj = mobilead::find($getMobileAds[0]['id']);
            $currentStep = AdminRole::where('id', 9)->get();
            $permitStep = new PermitStepMobile();
            $permitStep->purpose = 'New Mobile Ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $mobileObj->permitStepMobile()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve Mobile Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            $this->sendDetailsforQrcode($mobileId);
            return response()->json(['data' => $getMobileAds], 200);
        } else {
            return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }

    public function legalApprovalForOnpremise($onpremiseId) {

        if(Auth::user()->admin_role_id == 9) {

            $setLegalApproval = onpremise::where('id', $onpremiseId)->update(['legal_status' => 'approved', 'final_status' => 'approved']);
            $getOnpremiseAd = onpremise::where('id', $onpremiseId)->get();
            $onpremiseObj = onpremise::find($getOnpremiseAd[0]['id']);
            $currentStep = AdminRole::where('id', 9)->get();
            $permitStep = new PermitStepOnpremise();
            $permitStep->purpose = 'New Onpremise Ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $onpremiseObj->permitStepOnpremise()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve onpremise Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            return response()->json(['data' => $getOnpremiseAd], 200);
        } else {
            return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }

    public function legalApprovalForThirdPartyMobile($thirdpartyMobileId) {

        if(Auth::user()->admin_role_id == 9) {

            $setLegalApproval = ThirdPartyMobile::where('id', $thirdpartyMobileId)->update(['legal_status' => 'approved', 'final_status' => 'pending']);
            $getThirdPartyAd = ThirdPartyMobile::where('id', $thirdpartyMobileId)->get();
            $thirdPartyMobileObj = ThirdPartyMobile::find($getThirdPartyAd[0]['id']);
            $currentStep = AdminRole::where('id', 9)->get();
            $permitStep = new ThirdPartyMobilePermitStep();
            $permitStep->purpose = 'New Third Party Mobile Ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $thirdPartyMobileObj->thirdPartyMobilePermitStep()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve  Third Party Mobile Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            return response()->json(['data' => $getThirdPartyAd],200);
        } else {
            return response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }

    public function legalApprovalForStreetLamp($streetLampId) {

        if (Auth::user()->admin_role_id == 9) {

            $setLegalApproval = StreetLampsAds::where('id', $streetLampId)->update(['legal_status' => 'approved', 'final_status' => 'pending']);
            $getStreetLampAd = StreetLampsAds::where('id', $streetLampId)->get();
            $streetLampObj = StreetLampsAds::find($getStreetLampAd[0]['id']);
            $currentStep = AdminRole::where('id', 9)->get();
            $permitStep = new PermitStepStreetLamp();
            $permitStep->purpose = 'New Street Lamps ads';
            $permitStep->current_steps = $currentStep[0]['role'];
            $streetLampObj->permitStepStreetLamp()->save($permitStep);
            $user = Auth::user();
            $activityInfo = new AdminActivity();
            $fetchActivity ='Approve  Street Lamp Ads Application';
            $activityInfo->action = $fetchActivity;
            $activityInfo->user_admin_id = (string)$user->id;
            $activityInfo->save();
            return response()->json(['data' => $getStreetLampAd],200);
        } else {
            return  response()->json(['data' => 'You do not have the priviledge to take this action.'], 422);
        }
    }

    private function sendDetailsforQrcode($id) {

        $url = getenv('QRcode_URL');

        $headers = [
            'Authorization' => 'Bearer ' . getenv('QRcode_BEARER_TEST'),
            'Accept' => 'application/json',
            'Content-Type' => 'application/json'
        ];

        $getMobileDetails = mobilead::where('id', $id)->get();
        $getUserInfo = User::where('id', $getMobileDetails[0]['user_id'])->get();
        $getMobileLicense = MobileAdsVehicleLicense::where('mobilead_id', $id)->get();
        $count = count($getMobileLicense) - 1;
        $currentYear = date('Y');

        $data = [];

        for ($i=0; $i<= $count; $i++) {
            $postData = [
                'email' => $getUserInfo[0]['email'],
                'phone' => $getUserInfo[0]['phone_number'],
                'businessName' => $getUserInfo[0]['business_name'],
                'brandingType' => $getMobileLicense[$i]['branding_details'],
                'vehicleType' => $getMobileLicense[$i]['vehicle_type'],
                'permitYear' => $currentYear,
                'plateNumber' => $getMobileLicense[$i]['vehicle_license'],
                'branding_id' => $id
            ];
            $data [] = $postData;
        }

        $response = Http::withHeaders($headers)->post($url, $data);
        if($response->successful()) {
            $responseData = $response->json();

        } else {
            $responseData = "Unable to send data";
        }
        Log::info( response()->json(['data' => $responseData], $response->status()));
    }
}
