<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\mobilead;
use App\Models\MobileAdsVehicleLicense;
use App\Models\User;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ExternalController extends Controller {


//        public function postMobileDetailsforQrcode($mobileId)
//    {
//
//        $url = getenv('QRcode_URL');
//
//        $headers = [
//            'Authorization' => 'Bearer ' . getenv('QRcode_BEARER_TEST'),
//            'Accept' => 'application/json',
//            'Content-Type' => 'application/json'
//        ];
//
//        $getMobileDetails = mobilead::where('id', $mobileId)->get();
//        $getUserInfo = User::where('id', $getMobileDetails[0]['user_id'])->get();
//        $getMobileLicense = MobileAdsVehicleLicense::where('mobilead_id', $mobileId)->get();
//        $count = count($getMobileLicense) - 1;
//        $currentYear = date('Y');
//
//        $data = [];
//
//        for ($i=0; $i<= $count; $i++) {
//            $postData = [
//                    'email' => $getUserInfo[0]['email'],
//                    'phone' => $getUserInfo[0]['phone_number'],
//                    'businessName' => $getUserInfo[0]['business_name'],
//                    'brandingType' => $getMobileLicense[$i]['branding_details'],
//                    'vehicleType' => $getMobileLicense[$i]['vehicle_type'],
//                    'permitYear' => $currentYear,
//                    'plateNumber' => $getMobileLicense[$i]['vehicle_license'],
//                    'branding_id' => $mobileId
//            ];
//            $data [] = $postData;
//        }
//
//        $response = Http::withHeaders($headers)->post($url, $data);
//            if($response->successful()) {
//                $responseData = $response->json();
//
//            } else {
//                $responseData = "Unable to send data";
//            }
//            echo response()->json(['data' => $responseData], $response->status());
//        }

        public function getQrCodeDetails(Request $request) {
            if ($request->isMethod('PATCH')) {

                $validate = Validator::make($request->all(), [
                    'vehicledetails' => 'present|array',
                    'vehicledetails.*.branding_id' => 'required|numeric',
                    'vehicledetails.*.plateNumber' => 'required|string',
                    'vehicledetails.*.link' => 'required|string'
                ]);

                if ($validate->fails()) {
                    return response()->json(['errors' => $validate->errors()->all()], 422);
                }

                $dataInput = $request->all();
                //var_dump($dataInput['vehicledetails'][0]['vehicleLicense']); die();
                $count = count($dataInput['vehicledetails']) - 1;
                $responseData = '';

                for ($i = 0; $i <= $count; $i++) {
                    $mobileId = MobileAdsVehicleLicense::where('mobilead_id', $dataInput['vehicledetails'][$i]['branding_id'])->exists();
                    $vehicleLicense = MobileAdsVehicleLicense::where('vehicle_license',  $dataInput['vehicledetails'][$i]['plateNumber'])->exists();
                    if ($mobileId && $vehicleLicense) {
                        $updatetLicenseDetails = MobileAdsVehicleLicense::where('mobilead_id', $dataInput['vehicledetails'][$i]['branding_id'])
                                                                ->where('vehicle_license', $dataInput['vehicledetails'][$i]['plateNumber'])
                                                                ->update(['qrcode_link' => $dataInput['vehicledetails'][$i]['link']]);

                        $responseData = 'success';
                    } else {
                        $responseData = 'Invalid branding_id/platenumber';
                    }
                }
                return response()->json(['data' => $responseData], 200);
            }
        }
}
